/****** Object:  StoredProcedure [dbo].[P_ATIVA_EST_PED_ELTR_EST_PROD_TRANSF]    Script Date: 23/05/2014 11:35:40 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_ATIVA_EST_PED_ELTR_EST_PROD_TRANSF]') 
					AND type in (N'P', N'PC'))
	BEGIN
		DROP PROCEDURE [DBO].[P_ATIVA_EST_PED_ELTR_EST_PROD_TRANSF]
	END
GO

CREATE PROCEDURE [dbo].[P_ATIVA_EST_PED_ELTR_EST_PROD_TRANSF]  (@CD_EMP INT = 1, @CD_FILIAL INT=0)
WITH ENCRYPTION
AS
BEGIN
        
	SET NOCOUNT ON;

		DECLARE @CD_CTR INT;
		DECLARE @CD_PED_SOL INT;
		DECLARE @CD_ROTEIRO INT;
		DECLARE @CD_ROTEIRO_PARAM INT;

		SET @CD_ROTEIRO_PARAM = ISNULL((SELECT VALOR FROM PRC_EMP_CONFIG WHERE CD_EMP = @CD_EMP AND CD_CHAVE = 'ROTEIRO_PADRAO_COMPRA_POR_RESSUPRIMENTO'), 0)

		IF @CD_ROTEIRO_PARAM = 0 
		BEGIN
			RAISERROR ('Roteiro padrao para compra por ressuprimento atraves de pedido eletronico nao encontrado. 
							Por favor ajuste o parametro: ROTEIRO_PADRAO_COMPRA_POR_RESSUPRIMENTO . 
							Rotina: P_ATIVA_EST_PED_ELTR_EST_PROD_TRANSF',16, 1);
			RETURN;
		END
		 
		SELECT
			EST_PED_ELTR.CD_PED_SOL,
			EST_PED_ELTR_GRP_PED.CD_GRP_PED,
			COALESCE(EST_PED_ELTR_GRP_PED.CD_ROTEIRO_DEFAULT,@CD_ROTEIRO_PARAM) CD_ROTEIRO_DEFAULT
			into #tmpAtiva
		FROM
			EST_PED_ELTR
			JOIN EST_PED_ELTR_GRP_PED_EST_PED_ELTR ON 
			EST_PED_ELTR.CD_EMP = EST_PED_ELTR_GRP_PED_EST_PED_ELTR.CD_EMP AND 
			EST_PED_ELTR.CD_PED_SOL = EST_PED_ELTR_GRP_PED_EST_PED_ELTR.CD_PED_SOL 

			JOIN EST_PED_ELTR_GRP_PED ON 
			EST_PED_ELTR_GRP_PED_EST_PED_ELTR.CD_EMP = EST_PED_ELTR_GRP_PED.CD_EMP AND 
			EST_PED_ELTR_GRP_PED_EST_PED_ELTR.CD_GRP_PED = EST_PED_ELTR_GRP_PED.CD_GRP_PED   

			LEFT OUTER JOIN EST_PED_ELTR_ATIVA_CP_EST_PED_ELTR ON
			EST_PED_ELTR.CD_EMP = EST_PED_ELTR_ATIVA_CP_EST_PED_ELTR.CD_EMP AND 
			EST_PED_ELTR.CD_PED_SOL = EST_PED_ELTR_ATIVA_CP_EST_PED_ELTR.CD_PED_SOL
		WHERE
			EST_PED_ELTR.ATIVAR_PW_AUTOMATICO=1
			AND EST_PED_ELTR_ATIVA_CP_EST_PED_ELTR.CD_PED_SOL IS NULL;
		IF @@ROWCOUNT = 0
			RETURN;
-------------------------------------------------------------------------------------------------------------------------


		SET @CD_CTR = ISNULL((SELECT MAX(CD_CTR) FROM EST_PED_ELTR_ATIVA_CP	WHERE CD_EMP = 1),0) + 1;
-------------------------------------------------------------------------------------------------------------------------

		PRINT 'Remove demandas sem roteiros validos'
		DELETE FROM A
		FROM
			#tmpAtiva A
			LEFT JOIN EST_PED_CP_ROTEIRO_CP C ON 
			A.CD_ROTEIRO_DEFAULT = C.CD_ROTEIRO
		WHERE
			C.CD_ROTEIRO IS NULL;
-------------------------------------------------------------------------------------------------------------------------
		BEGIN TRAN		
			--CRIANDO A ATIVACAO
		   INSERT INTO EST_PED_ELTR_ATIVA_CP(CD_EMP, CD_CTR, CD_USU, DT_ATIVA, HR_ATIVA, STS_ATIVA)
		   SELECT
				  @CD_EMP
				, @CD_CTR + ROW_NUMBER() OVER(ORDER BY CD_GRP_PED) CD_CTR
				, 1 CD_USU
				, CONVERT(VARCHAR(10), GETDATE(), 102) DT_ATIVA
				, GETDATE()
				, 0 STS_ATIVA
		   FROM
				#tmpAtiva;

			--VINCULANDO A ATIVACAO COM O ROTEIRO
			INSERT INTO EST_PED_ELTR_ATIVA_CP_EST_PED_CP_ROTEIRO_CP( CD_EMP, CD_CTR, CD_ROTEIRO)
			SELECT
				  @CD_EMP
				, @CD_CTR + ROW_NUMBER() OVER(ORDER BY CD_GRP_PED)
				, CD_ROTEIRO_DEFAULT
			FROM
				#tmpAtiva;

			INSERT INTO EST_PED_ELTR_ATIVA_CP_EST_PED_ELTR(CD_EMP, CD_CTR, CD_PED_SOL)
			SELECT
				  @CD_EMP
				, @CD_CTR + ROW_NUMBER() OVER(ORDER BY CD_GRP_PED)
				, CD_PED_SOL
			FROM
				#tmpAtiva;				 
		COMMIT; 

	END
